<?php

namespace App\Models;

use CodeIgniter\Model;

class CertificateModel extends Model
{
    protected $table            = 'certificates';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nama_sertifikat', 'penerbit', 'tanggal_terbit', 'tanggal_expired',
        'nomor_sertifikat', 'link_sertifikat', 'foto_sertifikat', 'deskripsi',
        'created_at', 'updated_at'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function searchAndFilter($search = '', $filter = [], $sort = 'tanggal_terbit', $order = 'DESC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_sertifikat', $search)
                ->orLike('penerbit', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        }

        if (!empty($filter['penerbit'])) {
            $builder->where('penerbit', $filter['penerbit']);
        }

        if (!empty($filter['tanggal_dari'])) {
            $builder->where('tanggal_terbit >=', $filter['tanggal_dari']);
        }

        if (!empty($filter['tanggal_sampai'])) {
            $builder->where('tanggal_terbit <=', $filter['tanggal_sampai']);
        }

        $allowedSorts = ['tanggal_terbit', 'nama_sertifikat', 'penerbit', 'created_at'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'tanggal_terbit';
        $order = strtoupper($order) === 'ASC' ? 'ASC' : 'DESC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}

